#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using System.Text.RegularExpressions;

#endregion
namespace gov.va.med.vbecs.Common.UnitTests
{	

	
	

	[TestFixture]
	public class Common_RegularExpressions : BaseTest 
	{

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
		}


		[Test]
		public void CodabarUnitID_Pass()
		{
			Regex testEx = Common.RegularExpressions.CodabarUnitID();

			Assert.AreEqual(@"^([0-9]{2})?[A-Z0-9]{1,2}[0-9]{5,8}[A-Z]{0,1}$", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("01A01234567"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CodabarUnitID_Fail()
		{
		}

		[Test]
		public void ScannedCodabarUnitID_Pass()
		{
			Regex testEx = Common.RegularExpressions.ScannedCodabarUnitID();

			Assert.AreEqual(@"^[0-9]{6,10}$", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("01234567"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ScannedCodabarUnitID_Fail()
		{
		}

		[Test]
		public void ScannedISBT128UnitID_Pass()
		{
			Regex testEx = RegularExpressions.ScannedISBT128UnitID();

			Assert.AreEqual(@"^=?[A-Z]{1}[0-9]{12,14}$", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("A123456789012"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ScannedISBT128UnitID_Fail()
		{
		}

		[Test]
		public void ISBT128UnitID_Pass()
		{
			Regex testEx = RegularExpressions.ISBT128UnitID();

			Assert.AreEqual(@"[A-Z]{1}[0-9]{12}$", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("A123456789012"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ISBT128UnitID_Fail()
		{
		}

		[Test]
		public void FDARegistrationNumber_Pass()
		{
			Regex testEx = RegularExpressions.FDARegistrationNumber();

			Assert.AreEqual(@"(^\d{7}$)|(^\d{10}$)", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("1234567"), "IsMatch1");
			Assert.AreEqual(true, testEx.IsMatch("1234567890"), "IsMatch2");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void FDARegistrationNumber_Fail()
		{
		}

		[Test]
		public void CodabarProductCode_Pass()
		{
			Regex testEx = RegularExpressions.CodabarProductCode();

			Assert.AreEqual(@"^[0-9]{5,7}$", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("123456"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CodabarProductCode_Fail()
		{
		}

		[Test]
		public void ISBT128ProductCode_Pass()
		{
			Regex testEx = RegularExpressions.ISBT128ProductCode();
			
			Assert.AreEqual(@"^=?<?[A-Z]{1}[0-9]{4}[(?i:A-Za-z)0-9]{0,1}[A-Z0-9]{0,1}[a-z0-9]{0,1}$", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("A1234A01"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ISBT128ProductCode_Fail()
		{
		}

		[Test]
		public void UnitDivisionID_Pass()
		{
			Regex testEx = RegularExpressions.UnitDivisionId();

			Assert.AreEqual(@"^[A-Z]{1}[0-9]{1}$", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("A1"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void UnitDivisionID_Fail()
		{
		}

		[Test]
		public void Threshold_Pass()
		{
			Regex testEx = RegularExpressions.Threshold();

			Assert.AreEqual(@"^[<>]([ ]{0,1})([0-9]{1,3})(([.]{1}[0-9]{0,2}){0,1})$", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("<123.01"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Threshold_Fail()
		{
		}

		[Test]
		public void TextThreshold_Pass()
		{
			Regex testEx = RegularExpressions.ThresholdText();

			Assert.AreEqual(@"^[A-Za-z0-9=+, ]{1,255}$", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("ABCDEFGHIJ"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TextThreshold_Fail()
		{
		}

		[Test]
		public void ICCBBARegistrationNumber_Pass()
		{
			Regex testEx = RegularExpressions.IccbbaRegistrationNumber();

			Assert.AreEqual(@"^[A-Z]{1}[0-9]{4}$", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("A1234"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ICCBBARegistrationNumber_Fail()
		{
		}


		[Test]
		public void PhoneNumber_Pass()
		{
			Regex testEx = RegularExpressions.PhoneNumber();

			Assert.AreEqual(@"^\D?(\d{3})\D?\D?(\d{3})\D?(\d{4})$", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("(123)123-1234"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PhoneNumber_Fail()
		{
		}

		[Test]
		public void ZipCode_Pass()
		{
			Regex testEx = Common.RegularExpressions.ZipCode();

			Assert.AreEqual(@"^\d{5}(-\d{4})?$", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("48222-1746"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ZipCode_Fail()
		{
		}

		[Test]
		public void EmailAddress_Pass()
		{
			Regex testEx = Common.RegularExpressions.EmailAddress();

			Assert.AreEqual(@"^((?>[a-zA-Z\d!#$%&'*+\-/=?^_`{|}~]+\x20*|""((?=[\x01-\x7f])[^""\\]|\\[\x01-\x7f])*""\x20*)*(?<angle><))?((?!\.)(?>\.?[a-zA-Z\d!#$%&'*+\-/=?^_`{|}~]+)+|""((?=[\x01-\x7f])[^""\\]|\\[\x01-\x7f])*"")@(((?!-)[a-zA-Z\d\-]+(?<!-)\.)+[a-zA-Z]{2,}|\[(((?(?<!\[)\.)(25[0-5]|2[0-4]\d|[01]?\d?\d)){4}|[a-zA-Z\d\-]*[a-zA-Z\d]:((?=[\x01-\x7f])[^\\\[\]]|\\[\x01-\x7f])+)\])(?(angle)>)$", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("test@test.com"), "IsMatch1");
			Assert.AreEqual(true, testEx.IsMatch("John.Dow@domain.ext"), "IsMatch2");
			Assert.AreEqual(true, testEx.IsMatch("test@[127.0.0.1]"), "IsMatch3");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void EmailAddress_Fail()
		{
		}

		[Test]
		public void EyeReadablePrefixNumeric_Pass()
		{
			Regex testEx = Common.RegularExpressions.EyeReadablePrefixNumeric();

			Assert.AreEqual(@"^[0-9]{2}", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("12"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void EyeReadablePrefixNumeric_Fail()
		{
		}

		[Test]
		public void EyeReadableSuffixAlpha_Pass()
		{
			Regex testEx = Common.RegularExpressions.EyeReadableSuffixAlpha();

			Assert.AreEqual(@"^[A-Z]{1}", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("A"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void EyeReadableSuffixAlpha_Fail()
		{
		}

		[Test]
		public void EyeReadablePrefixAlphaNumeric_Pass()
		{
			Regex testEx = Common.RegularExpressions.EyeReadablePrefixAlphaNumeric();

			Assert.AreEqual(@"[A-Z0-9]{2}", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("A2"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void EyeReadablePrefixAlphaNumeric_Fail()
		{
		}

		
		[Test]
		public void PooledCodabarEyeReadableUnitId_Pass()
		{
			Regex testEx = Common.RegularExpressions.PooledCodabarEyeReadableUnitId();

			Assert.AreEqual(@"^[A-Za-z0-9]{6,13}", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("123AbC45g"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PooledCodabarEyeReadableUnitId_Fail()
		{
		}

		[Test]
		public void CodabarABORh_Pass()
		{
			Regex testEx = Common.RegularExpressions.CodabarABORh();

			Assert.AreEqual(@"[A-Z0-9]{1}[0-9]{1,2}", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("A12"), "IsMatch");
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CodabarABORh_Fail()
		{
		}

		[Test]
		public void CodabarExpirationDate_Pass()
		{
			Regex testEx = Common.RegularExpressions.CodabarExpirationDate();

			Assert.AreEqual(@"[0-9]{6,8}", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("123456"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CodabarExpirationDate_Fail()
		{
		}

		[Test]
		public void ISBT128ExpirationDate_Pass()
		{
			Regex testEx = Common.RegularExpressions.ISBT128ExpirationDate();
			
			Assert.AreEqual(@"&>[0-9]{6,10}", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("&>1234567890"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ISBT128ExpirationDate_Fail()
		{
		}


		[Test]
		public void PatientSsn_Pass()
		{
			Regex testEx = Common.RegularExpressions.PatientSsn();

			Assert.AreEqual(@"^[0-9]{4,9}([P]?)$", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("123456789"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PatientSsn_Fail()
		{
		}

		[Test]
		public void PatientName_Pass()
		{
			Regex testEx = Common.RegularExpressions.PatientName();

			Assert.AreEqual(@"^([A-Z]+)$", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("ABCDEFGHIJKLMNOPQRSTUVWXYZ"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PatientName_Fail()
		{
		}

		[Test]
		public void PatientInitialAndLastFourSSN_Pass()
		{
			Regex testEx = Common.RegularExpressions.PatientInitialAndLastFourSSN();

			Assert.AreEqual(@"^[A-Za-z]{1}[0-9]{4}$", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("A1234"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PatientInitialAndLastFourSSN_Fail()
		{
		}

		
		[Test]
		public void LastFourSSN_Pass()
		{
			Regex testEx = Common.RegularExpressions.LastFourSSN();

			Assert.AreEqual(@"^[0-9]{4}$", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("8068"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LastFourSSN_Fail()
		{
		}

		[Test]
		public void SpecimenAccessionNumber_Pass()
		{
			Regex testEx = Common.RegularExpressions.SpecimenAccessionNumber();

			Assert.AreEqual(@"BB [0-9]{4} [0-9]+", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("BB 1234 567890"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SpecimenAccessionNumber_Fail()
		{
		}

		[Test]
		public void SpecimenUid_Pass()
		{
			Regex testEx = Common.RegularExpressions.SpecimenUid();

			Assert.AreEqual(@"^\w{10,15}$", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("123456789012345"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SpecimenUid_Fail()
		{
		}

		[Test]
		public void ReturnCreditAmount_Pass()
		{
			Regex testEx = Common.RegularExpressions.ReturnCreditAmount();

			Assert.AreEqual(@"^[0-9]+(\.[0-9]{1,2})?$", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("12.34"), "IsMatch");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReturnCreditAmount_Fail()
		{
		}

		[Test]
		public void IPAddress_Pass()
		{
			Regex testEx = Common.RegularExpressions.IPAddress();

			Assert.AreEqual(@"\A(((25[0-5])|(2[0-4]\d)|(1\d{2})|(0?\d{1,2}))\.){3}((25[0-5])|(2[0-4]\d)|(1\d{2})|(0?\d{1,2}))\Z", testEx.ToString(), "ExpressionValue");
			Assert.AreEqual(true, testEx.IsMatch("10.3.17.8"), "IsMatch");
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IPAddress_Fail() {}

		[Test]
		public void SsnNoDashes_Pass()
		{
			Regex testEx = Common.RegularExpressions.SsnNoDashes();

			Assert.AreEqual(@"\A\d{9}\Z", testEx.ToString(), "ExpressionValue");

			Assert.AreEqual(true, testEx.IsMatch( "123456789" ), "IsMatch1" );
			Assert.AreEqual(false, testEx.IsMatch( "1234578a" ), "IsMatch2" );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SsnNoDashes_Fail() 
		{
		}

		[Test]
		public void VistADuz_Pass()
		{
			Regex testEx = Common.RegularExpressions.VistADuz();

			Assert.AreEqual(@"\A\d{1,19}\Z", testEx.ToString(), "ExpressionValue");

			Assert.AreEqual(true, testEx.IsMatch( "1" ), "IsMatch1" );
			Assert.AreEqual(true, testEx.IsMatch( "11234" ), "IsMatch2" );
			Assert.AreEqual(true, testEx.IsMatch( "999999999" ), "IsMatch3" );
			Assert.AreEqual(true, testEx.IsMatch( "9999999991111111111" ), "IsMatch7" );

			Assert.AreEqual(false, testEx.IsMatch( "1234578a" ), "IsMatch4" );
			Assert.AreEqual(false, testEx.IsMatch( "" ), "IsMatch5" );
			Assert.AreEqual(false, testEx.IsMatch( "12345678901234567890" ), "IsMatch6" );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void VistADuz_Fail() 
		{
		}

		[Test]
		public void DivisionCode_Pass()
		{
			Regex testEx = Common.RegularExpressions.DivisionCode();

			Assert.AreEqual(@"\A[\w\s]{1,5}\Z", testEx.ToString(), "ExpressionValue");

			Assert.AreEqual(true, testEx.IsMatch( "1" ), "IsMatch1" );
			Assert.AreEqual(true, testEx.IsMatch( "589A4" ), "IsMatch2" );
			Assert.AreEqual(true, testEx.IsMatch( "ABS12" ), "IsMatch3" );

			Assert.AreEqual(false, testEx.IsMatch( "ABCDEFG" ), "IsMatch4" );
			Assert.AreEqual(false, testEx.IsMatch( "" ), "IsMatch5" );
			Assert.AreEqual(false, testEx.IsMatch( "1234567890" ), "IsMatch6" );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DivisionCode_Fail() 
		{
		}

		[Test]
		public void DivisionName_Pass()
		{
			Regex testEx = Common.RegularExpressions.DivisionName();

			Assert.AreEqual(@"\A[\w]{1}.{0,49}\Z", testEx.ToString(), "ExpressionValue");

			Assert.AreEqual(true, testEx.IsMatch( "1" ), "IsMatch1" );
			Assert.AreEqual(true, testEx.IsMatch( "Hey Ho!" ), "IsMatch2" );
			Assert.AreEqual(true, testEx.IsMatch( "Medical Center" ), "IsMatch3" );

			Assert.AreEqual(false, testEx.IsMatch( "" ), "IsMatch4" );
			Assert.AreEqual(false, testEx.IsMatch( "**********" ), "IsMatch5" );
			Assert.AreEqual(false, testEx.IsMatch( "a".PadRight(100, 'A' ) ), "IsMatch6" );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DivisionName_Fail()
		{
		}	

		[Test]
		public void IntegerOrDecimal_Pass()
		{
			Regex testEx = Common.RegularExpressions.IntegerOrDecimal();

			Assert.AreEqual(@"^\d+\z|^\d+[.]\d*\z|^\d*[.]\d+\z", testEx.ToString(), "ExpressionValue");

			Assert.AreEqual(true, testEx.IsMatch( "1" ), "PASS: 1" );
			Assert.AreEqual(true, testEx.IsMatch( "01.07" ), "PASS: 01.07" );
			Assert.AreEqual(true, testEx.IsMatch( ".04" ), "PASS: .04" );
			Assert.AreEqual(true, testEx.IsMatch( ".3" ), "PASS: .3" );
			Assert.AreEqual(true, testEx.IsMatch( "28." ), "PASS: 28." );
			Assert.AreEqual(true, testEx.IsMatch( "1.090" ), "PASS: 1.090" );
			Assert.AreEqual(true, testEx.IsMatch( "001.000" ), "PASS: 001.000" );

			Assert.AreEqual(false, testEx.IsMatch( "a08" ), "FAIL: a08" );
			Assert.AreEqual(false, testEx.IsMatch( "**********" ), "FAIL: **********" );
			Assert.AreEqual(false, testEx.IsMatch( "01D.83" ), "FAIL: 01D.83" );
			Assert.AreEqual(false, testEx.IsMatch( "55f" ), "FAIL: 55f" );
			Assert.AreEqual(false, testEx.IsMatch( "TEST" ), "FAIL: TEST" );
			Assert.AreEqual(false, testEx.IsMatch( "23G75" ), "FAIL: 23G75" );
			Assert.AreEqual(false, testEx.IsMatch( " " ), "FAIL:  " );
			Assert.AreEqual(false, testEx.IsMatch( "." ), "FAIL: ." );
			Assert.AreEqual(false, testEx.IsMatch( "E.5" ), "FAIL: E.5" );
			Assert.AreEqual(false, testEx.IsMatch( "CATS#" ), "FAIL: CATS#" );
			Assert.AreEqual(false, testEx.IsMatch( "12.34G" ), "FAIL: 12.34G" );
			Assert.AreEqual(false, testEx.IsMatch( "0.x" ), "FAIL: 0.x" );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IntegerOrDecimal_Fail()
		{
		}	
	}
}
#endif

